<?php
add_action( 'vc_before_init', 'dtdr_sf_output_map_container_vc_map' );

function dtdr_sf_output_map_container_vc_map() {

	$listing_singular_label = apply_filters( 'listing_label', 'singular' );
	
	vc_map( array (
		"name" => esc_html__( 'Output Map Container', 'dtdr' ),
		"base" => "dtdr_sf_output_map_container",
		"icon" => "dtdr_sf_output_map_container",
		"category" => DTDR_PB_MODULE_SEARCHFORM_TITLE,
		"params" => array_merge (

						array (

							// Type
							array(
								'type' => 'dropdown',
								'heading' => esc_html__('Type','dtdr'),
								'param_name' => 'type',
								'value' => array(
									esc_html__( 'Type 1', 'dtdr' ) => 'type1',
									esc_html__( 'Type 2', 'dtdr' ) => 'type2',
									esc_html__( 'Type 3', 'dtdr' ) => 'type3'
								),
								'description' => esc_html__('Choose type of layout you like to display.', 'dtdr'),
								'edit_field_class' => 'vc_column vc_col-sm-6',
							),

							// Gallery
							array (
								'type' => 'dropdown',
								'heading' => esc_html__('Gallery','dtdr'),
								'param_name' => 'gallery',
								'value' => array(
									esc_html__('Featured Image', 'dtdr') => 'featured_image',
									esc_html__('Image Gallery', 'dtdr') => 'image_gallery',
									esc_html__('Image Gallery With Featured Image', 'dtdr') => 'gallery_with_featured',
								),
								'description' => esc_html__( 'Choose how you like to display image gallery.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'std' => 'featured_image',
							),

							// Additional Info
							array (
								'type' => 'dropdown',
								'heading' => esc_html__('Additional Info','dtdr'),
								'param_name' => 'additional_info',
								'value' => array(
									esc_html__('None', 'dtdr')            => '',
									esc_html__('Total Views', 'dtdr')     => 'totalviews',
									esc_html__('Average Ratings', 'dtdr') => 'averageratings',
									esc_html__('Category Image', 'dtdr')  => 'categoryimage',
									esc_html__('Category Icon', 'dtdr')   => 'categoryicon',
									esc_html__('Distance', 'dtdr')        => 'distance'
								),
								'description' => esc_html__( 'Choose additional info that you like to display along with location marker.', 'dtdr' ),
								'std' => '',
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'admin_label' => true
							),

							// Background Color
				      		array(
				      			'type' => 'colorpicker',
				      			'heading' => esc_html__( 'Background Color', 'dtdr' ),
				      			'param_name' => 'category_background_color',
								'dependency' => array( 'element' => 'additional_info', 'value' => array ('categoryimage', 'categoryicon') ),
				      			'description' => esc_html__( 'Select background color for your icon. icon will be taken from the category settings.', 'dtdr' ),
				      			'edit_field_class' => 'vc_column vc_col-sm-6',
				      		),

							// Icon Color
				      		array(
				      			'type' => 'colorpicker',
				      			'heading' => esc_html__( 'Icon Color', 'dtdr' ),
				      			'param_name' => 'category_color',
								'dependency' => array( 'element' => 'additional_info', 'value' => array ('categoryimage', 'categoryicon') ),
				      			'description' => esc_html__( 'Select icon color for your icon. icon will be taken from the category settings.', 'dtdr' ),
				      			'edit_field_class' => 'vc_column vc_col-sm-6',
				      		),

							// Zoom Level
							array(
								'type' => 'textfield',
								'heading' => esc_html__( 'Zoom Level', 'dtdr' ),
								'param_name' => 'zoom_level',
								'description' => esc_html__( 'Add map zoom level here. This will overwrite the default map zoom level. Ex: ... 9, 10, 11...', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
							),

							// Map Type
							array (
								'type' => 'dropdown',
								'heading' => esc_html__('Map Type','dtdr'),
								'param_name' => 'map_type',
								'value' => array(
									esc_html__('Default', 'dtdr') => '',
									esc_html__('SATELLITE', 'dtdr') => 'SATELLITE',
									esc_html__('HYBRID', 'dtdr') => 'HYBRID',
									esc_html__('TERRAIN', 'dtdr') => 'TERRAIN',
									esc_html__('ROADMAP', 'dtdr') => 'ROADMAP',
								),
								'description' => esc_html__( 'Choose map type for this item.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
							),

							// Map Color
				      		array(
				      			'type' => 'colorpicker',
				      			'heading' => esc_html__( 'Map Color', 'dtdr' ),
				      			'param_name' => 'map_color',
				      			'description' => esc_html__( 'Select color for your map. This will override the default map color.', 'dtdr' ),
				      			'edit_field_class' => 'vc_column vc_col-sm-6'
				      		),

							// Height
							array (
								'type' => 'textfield',
								'heading' => esc_html__( 'Height', 'dtdr' ),
								'param_name' => 'vc_height',
								'description' => esc_html__( 'Provide height for your map in "px" here.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6'
							),

							// Class
							array (
								'type' => 'textfield',
								'heading' => esc_html__( 'Class', 'dtdr' ),
								'param_name' => 'class',
								'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6'
							),

							// Filter Options

							// Category Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s Category Ids', 'dtdr'), $listing_singular_label ),
								'param_name' => 'category_ids',
								'value' => '',
								'description' => esc_html__( 'Enter category ids separated by commas.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

						)

					)

	) );

}
?>