<?php

function dtdr_settings_map_content() {

	$output = '';

	$output .= '<form name="formOptionSettings" class="formOptionSettings" method="post">';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<label><strong>'.esc_html__( 'Map', 'dtdr') .'</strong></label>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable Auto Complete In Frontend Form Submission', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
				$checked = ( 'true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission') ) ? ' checked="checked"' : '';
				$switchclass = ( 'true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
				$output .= '<div data-for="enable-autocomplete-frontend-formsubmission" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
				$output .= '<input id="enable-autocomplete-frontend-formsubmission" class="hidden" type="checkbox" name="dtdr[map][enable-autocomplete-frontend-formsubmission]" value="true" '.$checked.' />';
				$output .= '<div class="dtdr-note">'.esc_html__( 'You can enable google places auto complete for locations in frontend form submission.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable SSL', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
                $checked = ( 'true' ==  dtdr_option('map','enable-ssl') ) ? ' checked="checked"' : '';
                $switchclass = ( 'true' ==  dtdr_option('map','enable-ssl') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
	            $output .= '<div data-for="enable-ssl" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
	            $output .= '<input id="enable-ssl" class="hidden" type="checkbox" name="dtdr[map][enable-ssl]" value="true" '.$checked.' />';
	            $output .= '<div class="dtdr-note">'.esc_html__( 'You can load map with SSL certificate.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Google Map - API Key', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $googlemap_api_key = dtdr_option('map','googlemap-api-key');
	            $output .= '<input id="googlemap-api-key" name="dtdr[map][googlemap-api-key]" type="text" value="'.$googlemap_api_key.'" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Add your google map API key here.', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Default Latitude', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $default_latitude = dtdr_option('map','default-latitude');
	            $output .= '<input id="default-latitude" name="dtdr[map][default-latitude]" type="text" value="'.$default_latitude.'" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Provide default latitude value.', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Default Longitude', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $default_longitude = dtdr_option('map','default-longitude');
	            $output .= '<input id="default-longitude" name="dtdr[map][default-longitude]" type="text" value="'.$default_longitude.'" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Provide default longitude value.', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Default Zoom Level', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $default_zoom_level = dtdr_option('map','default-zoom-level');
	            $output .= '<input id="default-zoom-level" name="dtdr[map][default-zoom-level]" type="number" value="'.$default_zoom_level.'" min="1" max="20" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Add default zoom level here. Range - ( 1 to 20 )', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__('Default Map Type', 'dtdr').'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';

				$map_types = array ('SATELLITE','HYBRID','TERRAIN','ROADMAP');
				$default_map_type = dtdr_option('map','default-map-type');

	            $output .= '<select id="default-map-type" name="dtdr[map][default-map-type]" class="dtdr-chosen-select">';
					foreach($map_types as $map_type) {
						$output .= '<option value="'.$map_type.'" '.selected($map_type, $default_map_type, false).'>';
							$output .= $map_type;
						$output .= '</option>';
					}
				$output .= '</select>';
	            $output .= '<div class="dtdr-note">'.esc_html__('Choose deafult map type here.', 'dtdr').'</div>';

			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Default Map Color', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $map_color = dtdr_option('map','default-map-color');
	            $output .= '<input id="default-map-color" name="dtdr[map][default-map-color]" class="dtdr-color-field color-picker" data-alpha="true" type="text" value="'.$map_color.'" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Choose map color', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable Map Type Control', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
                $checked = ( 'true' ==  dtdr_option('map','enable-maptype-control') ) ? ' checked="checked"' : '';
                $switchclass = ( 'true' ==  dtdr_option('map','enable-maptype-control') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
	            $output .= '<div data-for="enable-maptype-control" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
	            $output .= '<input id="enable-maptype-control" class="hidden" type="checkbox" name="dtdr[map][enable-maptype-control]" value="true" '.$checked.' />';
	            $output .= '<div class="dtdr-note">'.esc_html__( 'If you wish you can enable map type control here.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable Zoom Control', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
                $checked = ( 'true' ==  dtdr_option('map','enable-zoom-control') ) ? ' checked="checked"' : '';
                $switchclass = ( 'true' ==  dtdr_option('map','enable-zoom-control') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
	            $output .= '<div data-for="enable-zoom-control" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
	            $output .= '<input id="enable-zoom-control" class="hidden" type="checkbox" name="dtdr[map][enable-zoom-control]" value="true" '.$checked.' />';
	            $output .= '<div class="dtdr-note">'.esc_html__( 'If you wish you can enable zoom control here.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable Scale Control', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
                $checked = ( 'true' ==  dtdr_option('map','enable-scale-control') ) ? ' checked="checked"' : '';
                $switchclass = ( 'true' ==  dtdr_option('map','enable-scale-control') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
	            $output .= '<div data-for="enable-scale-control" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
	            $output .= '<input id="enable-scale-control" class="hidden" type="checkbox" name="dtdr[map][enable-scale-control]" value="true" '.$checked.' />';
	            $output .= '<div class="dtdr-note">'.esc_html__( 'If you wish you can enable scale control here.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable Street View Control', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
                $checked = ( 'true' ==  dtdr_option('map','enable-streetview-control') ) ? ' checked="checked"' : '';
                $switchclass = ( 'true' ==  dtdr_option('map','enable-streetview-control') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
	            $output .= '<div data-for="enable-streetview-control" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
	            $output .= '<input id="enable-streetview-control" class="hidden" type="checkbox" name="dtdr[map][enable-streetview-control]" value="true" '.$checked.' />';
	            $output .= '<div class="dtdr-note">'.esc_html__( 'If you wish you can enable street view control here.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable Fullscreen Control', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
                $checked = ( 'true' ==  dtdr_option('map','enable-fullscreen-control') ) ? ' checked="checked"' : '';
                $switchclass = ( 'true' ==  dtdr_option('map','enable-fullscreen-control') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
	            $output .= '<div data-for="enable-fullscreen-control" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
	            $output .= '<input id="enable-fullscreen-control" class="hidden" type="checkbox" name="dtdr[map][enable-fullscreen-control]" value="true" '.$checked.' />';
	            $output .= '<div class="dtdr-note">'.esc_html__( 'If you wish you can enable fullscreen control here.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';


		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<label><strong>'.esc_html__( 'Location', 'dtdr') .'</strong></label>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Enable Auto Complete In Frontend Form Submission', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
				$checked = ( 'true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission') ) ? ' checked="checked"' : '';
				$switchclass = ( 'true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
				$output .= '<div data-for="enable-autocomplete-frontend-formsubmission" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
				$output .= '<input id="enable-autocomplete-frontend-formsubmission" class="hidden" type="checkbox" name="dtdr[map][enable-autocomplete-frontend-formsubmission]" value="true" '.$checked.' />';
				$output .= '<div class="dtdr-note">'.esc_html__( 'You can enable google places auto complete for locations in frontend form submission.', 'dtdr' ).'</div>';
			$output .= '</div>';
		$output .= '</div>';


		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<label><strong>'.esc_html__( 'Permalinks', 'dtdr') .'</strong></label>';
		$output .= '</div>';

		$listing_singular_label = apply_filters( 'listing_label', 'singular' );

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.sprintf( esc_html__( '%1$s City Slug', 'dtdr' ), $listing_singular_label ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $dtdr_listings_city_slug = dtdr_option('map','listing-city-slug');
	            $output .= '<input id="listing-city-slug" name="dtdr[map][listing-city-slug]" type="text" value="'.$dtdr_listings_city_slug.'" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Do not use characters not allowed in links. Use, eg. listing-city After change go to Settings > Permalinks and click Save changes.', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.sprintf( esc_html__( '%1$s Neighborhood Slug', 'dtdr' ), $listing_singular_label ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $dtdr_listings_neighborhood_slug = dtdr_option('map','listing-neighborhood-slug');
	            $output .= '<input id="listing-neighborhood-slug" name="dtdr[map][listing-neighborhood-slug]" type="text" value="'.$dtdr_listings_neighborhood_slug.'" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Do not use characters not allowed in links. Use, eg. listing-neighborhood After change go to Settings > Permalinks and click Save changes.', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.sprintf( esc_html__( '%1$s County / State Slug', 'dtdr' ), $listing_singular_label ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
	            $dtdr_listings_countystate_slug = dtdr_option('map','listing-countystate-slug');
	            $output .= '<input id="listing-countystate-slug" name="dtdr[map][listing-countystate-slug]" type="text" value="'.$dtdr_listings_countystate_slug.'" />';
	            $output .= '<div class="dtdr-note">'.esc_html__('Do not use characters not allowed in links. Use, eg. listing-countystate After change go to Settings > Permalinks and click Save changes.', 'dtdr').'</div>';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-note">'.esc_html__('Do not use characters not allowed in links. Use, eg. courses After change go to Settings > Permalinks and click Save changes.', 'dtdr').'</div>';

		$output .= '<div class="dtdr-option-settings-response-holder"></div>';

		$output .= '<a href="#" class="custom-button-style dtdr-save-options-settings" data-settings="map">'.esc_html__('Save Settings', 'dtdr').'</a>';

	$output .= '</form>';

	return $output;

}

echo dtdr_settings_map_content();

?>