<?php

// Update map based on filter

if( !function_exists('dtdr_generate_load_search_map_ouput') ) {
  function dtdr_generate_load_search_map_ouput() {

    $mapdata_complete = array ();

    $output = '';

    $type = (isset($_REQUEST['type']) && $_REQUEST['type'] != '') ? dtdr_recursive_sanitize_text_field($_REQUEST['type']) : 'type1';

    $zoom_level = isset($_REQUEST['zoom_level']) ? dtdr_recursive_sanitize_text_field($_REQUEST['zoom_level']) : dtdr_option('map','default-zoom-level');
    $map_type = isset($_REQUEST['map_type']) ? dtdr_recursive_sanitize_text_field($_REQUEST['map_type']) : dtdr_option('map', 'default-map-type');
    $map_color = isset($_REQUEST['map_color']) ? dtdr_recursive_sanitize_text_field($_REQUEST['map_color']) : dtdr_option('map', 'default-map-color');

    $user_latitude = isset($_REQUEST['user_latitude']) ? dtdr_recursive_sanitize_text_field($_REQUEST['user_latitude']) : '';
    $user_longitude = isset($_REQUEST['user_longitude']) ? dtdr_recursive_sanitize_text_field($_REQUEST['user_longitude']) : '';
    $radius_unit = dtdr_recursive_sanitize_text_field($_REQUEST['radius_unit']);

    $itemids = dtdr_recursive_sanitize_text_field($_REQUEST['itemids']);
    $additional_info = dtdr_recursive_sanitize_text_field($_REQUEST['additional_info']);
    $category_background_color = dtdr_recursive_sanitize_text_field($_REQUEST['category_background_color']);
    $category_color = dtdr_recursive_sanitize_text_field($_REQUEST['category_color']);

    $mapdefaults[0]['zoom_level'] = $zoom_level;
    $mapdefaults[0]['map_type'] = $map_type;
    $mapdefaults[0]['map_color'] = $map_color;

    if(empty($itemids)) {

      if($user_latitude != '' && $user_longitude != '') {
        $mapdefaults[0]['latitude'] = $user_latitude;
        $mapdefaults[0]['longitude'] = $user_longitude;
        $mapdefaults[0]['image'] = DTDR_LOCATION_PLUGIN_URL.'assets/images/user.png';
        $mapdefaults[0]['origin'] = 'user';
      } else {
        $mapdefaults[0]['latitude'] = dtdr_option('map','default-latitude');
        $mapdefaults[0]['longitude'] = dtdr_option('map','default-longitude');
        $mapdefaults[0]['origin'] = 'default';
      }

        echo json_encode(array(
          'mapdefaults' => $mapdefaults,
            'mapdata' => $mapdata_complete,
        ));

      die();

    }

    if(is_array($itemids) && !empty($itemids)) {

      foreach($itemids as $listing_id) {

        $dtdr_latitude = get_post_meta($listing_id, 'dtdr_latitude', true);
        $dtdr_longitude = get_post_meta($listing_id, 'dtdr_longitude', true);

        if($dtdr_latitude != '' && $dtdr_longitude != '') {

          $dtdr_map_image = get_post_meta($listing_id, 'dtdr_map_image', true);
          $image_url = wp_get_attachment_image_src($dtdr_map_image, 'thumbnail');
          $map_image = (isset($image_url[0]) && !empty($image_url[0])) ? $image_url[0] : DTDR_LOCATION_PLUGIN_URL.'assets/images/marker.png';

          $total_views = get_post_meta($listing_id, 'dtdr_total_views', true);

          $average_ratings = get_post_meta($listing_id, 'dtdr_average_ratings', true);

          $mapdata = array ();

          $mapdata[$listing_id]['listingid'] = $listing_id;
          $mapdata[$listing_id]['latitude'] = $dtdr_latitude;
          $mapdata[$listing_id]['longitude'] = $dtdr_longitude;
          $mapdata[$listing_id]['image'] = $map_image;

          if($additional_info == 'totalviews') {
            $mapdata[$listing_id]['additionalinfotype'] = 'totalviews';
            $mapdata[$listing_id]['additionalinfo'] = $total_views;
          }

          if($additional_info == 'averageratings') {
            $mapdata[$listing_id]['additionalinfotype'] = 'averageratings';
            $mapdata[$listing_id]['additionalinfo'] = $average_ratings;
          }

          if($additional_info == 'categoryimage') {

            $listing_terms = get_the_terms($listing_id, 'dtdr_listings_category');
            if(is_array($listing_terms) && !empty($listing_terms)) {
              foreach ( $listing_terms as $listing_term ) {
                if( $listing_term->parent == 0 ) {
                  $listing_term_id = $listing_term->term_id;
                  break;
                } else {
                  $listing_term_id = $listing_term->term_id;
                }
              }
            }

            $image_url = get_term_meta( $listing_term_id, 'dtdr-taxonomy-map-image-url', true );

            $mapdata[$listing_id]['additionalinfotype'] = 'categoryimage';
            $mapdata[$listing_id]['additionalinfo'] = $image_url;

            if((isset($category_background_color) && $category_background_color!= '') && (isset($category_color) && $category_color!= '')) {

              $mapdata[$listing_id]['categorybackgroundcolor'] = $category_background_color;
              $mapdata[$listing_id]['categorycolor'] = $category_color;

            } else {

              $background_color = get_term_meta($listing_term_id, 'dtdr-taxonomy-background-color', true);
              $icon_color = get_term_meta($listing_term_id, 'dtdr-taxonomy-icon-color', true);

              $mapdata[$listing_id]['categorybackgroundcolor'] = $background_color;
              $mapdata[$listing_id]['categorycolor'] = $icon_color;

            }

          }

          if($additional_info == 'categoryicon') {

            $listing_terms = get_the_terms($listing_id, 'dtdr_listings_category');

            if(is_array($listing_terms) && !empty($listing_terms)) {
              foreach ( $listing_terms as $listing_term ) {
                if( $listing_term->parent == 0 ) {
                  $listing_term_id = $listing_term->term_id;
                  break;
                } else {
                  $listing_term_id = $listing_term->term_id;
                }
              }
            }

            $icon = get_term_meta($listing_term_id, 'dtdr-taxonomy-icon', true);

            $mapdata[$listing_id]['additionalinfotype'] = 'categoryicon';
            $mapdata[$listing_id]['additionalinfo'] = $icon;

            if((isset($category_background_color) && $category_background_color!= '') && (isset($category_color) && $category_color!= '')) {

              $mapdata[$listing_id]['categorybackgroundcolor'] = $category_background_color;
              $mapdata[$listing_id]['categorycolor'] = $category_color;

            } else {

              $background_color = get_term_meta($listing_term_id, 'dtdr-taxonomy-background-color', true);
              $icon_color = get_term_meta($listing_term_id, 'dtdr-taxonomy-icon-color', true);

              $mapdata[$listing_id]['categorybackgroundcolor'] = $background_color;
              $mapdata[$listing_id]['categorycolor'] = $icon_color;

            }

          }

          if($additional_info == 'distance') {

            $dtdr_latitude = get_post_meta($listing_id, 'dtdr_latitude', true);
            $dtdr_longitude = get_post_meta($listing_id, 'dtdr_longitude', true);

            $mapdata[$listing_id]['additionalinfotype'] = 'distance';

            $radius_calculated = 0;
            if($user_latitude != '' && $user_longitude != '') {
              $radius_calculated = dtdr_calculate_distance_between_location($user_latitude, $user_longitude, $dtdr_latitude, $dtdr_longitude, $radius_unit);
              $mapdata[$listing_id]['additionalinfo'] = $radius_calculated.' '.$radius_unit;
            } else {
              $mapdata[$listing_id]['additionalinfo'] = '';
            }

          }

          // Map Info Popup Content

          $listing_title = get_the_title($listing_id);
          $listing_permalink = get_permalink($listing_id);

          $data_listing_attributes = array ();
          $data_listing_attributes['listing_id'] = $listing_id;
          $data_listing_attributes['listing_title'] = $listing_title;
          $data_listing_attributes['listing_permalink'] = $listing_permalink;
          $data_listing_attributes['type'] = $type;

          $mapdata[$listing_id]['infocontent'] = dtdr_generate_listing_map_item_html($data_listing_attributes);


          // Final array

          $mapdata_complete = array_merge($mapdata_complete, $mapdata);

        }


      }

    }

    if($user_latitude != '' && $user_longitude != '') {
      $mapdefaults[0]['latitude'] = $user_latitude;
      $mapdefaults[0]['longitude'] = $user_longitude;
      $mapdefaults[0]['image'] = DTDR_LOCATION_PLUGIN_URL.'assets/images/user.png';
      $mapdefaults[0]['origin'] = 'user';
    } else {
      $mapdefaults[0]['latitude'] = $mapdata_complete[0]['latitude'];
      $mapdefaults[0]['longitude'] = $mapdata_complete[0]['longitude'];
      $mapdefaults[0]['infocontent'] = $mapdata_complete[0]['infocontent'];
      $mapdefaults[0]['origin'] = 'default';
    }


      echo json_encode(array(
          'mapdefaults' => $mapdefaults,
          'mapdata' => $mapdata_complete,
      ));

    die();

  }
  add_action( 'wp_ajax_dtdr_generate_load_search_map_ouput', 'dtdr_generate_load_search_map_ouput' );
  add_action( 'wp_ajax_nopriv_dtdr_generate_load_search_map_ouput', 'dtdr_generate_load_search_map_ouput' );
}

// Frontend Listing Map - Generate Html

if( !function_exists('dtdr_generate_listing_map_item_html') ) {
  function dtdr_generate_listing_map_item_html($data_listing_attributes) {

    $output = '';

    extract($data_listing_attributes);

    $item_classes = array ('dtdr-listings-map-item-wrapper');
    array_push($item_classes, $type);


    if($type == 'type1') {

      $output .= '<div class="'.implode(' ', get_post_class($item_classes, $listing_id)).'">';

        $output .= '<div class="dtdr-listings-item-top-section">';

          $output .= '<div class="dtdr-listings-item-image-gallery">';
            $output .= do_shortcode('[dtdr_sp_featured_image listing_id="'.esc_attr($listing_id).'" image_size="full" /]');
          $output .= '</div>';

          $output .= '<div class="dtdr-listings-item-top-section-content">';

            $output .= '<div class="dtdr-listings-utils-item-holder">';
              $output .= dtdr_favourite_marker_html($listing_id);
              $output .= '<div class="dtdr-listings-utils-item dtdr-listings-utils-totalimages">';
                $output .= '<div class="dtdr-listings-utils-totalimages-item"><span class="far fa-images"></span><p>'.esc_html($total_images_cnt).'</p></div>';
              $output .= '</div>';
            $output .= '</div>';

          $output .= '</div>';

        $output .= '</div>';

        $output .= '<div class="dtdr-listings-item-bottom-section">';

          $output .= '<div class="dtdr-listings-item-title">';
            $output .= '<a href="'.get_permalink($listing_id).'">'.get_the_title($listing_id).'</a>';
          $output .= '</div>';

          if(shortcode_exists('dtdr_sp_price')) {
            $output .= do_shortcode('[dtdr_sp_price listing_id="'.esc_attr($listing_id).'" /]');
          }

        $output .= '</div>';

      $output .= '</div>';

    } else if($type == 'type2') {

      $output .= '<div class="'.implode(' ', get_post_class($item_classes, $listing_id)).'">';

        $output .= '<div class="dtdr-listings-item-top-section">';

          $output .= '<div class="dtdr-listings-item-image-gallery">';
            $output .= do_shortcode('[dtdr_sp_featured_image listing_id="'.esc_attr($listing_id).'" image_size="full" /]');
          $output .= '</div>';

        $output .= '</div>';

        $output .= '<div class="dtdr-listings-item-bottom-section">';

          $output .= '<div class="dtdr-listings-utils-item-holder">';
            $output .= dtdr_favourite_marker_html($listing_id);
            $output .= '<div class="dtdr-listings-utils-item dtdr-listings-utils-totalimages">';
              $output .= '<div class="dtdr-listings-utils-totalimages-item"><span class="far fa-images"></span><p>'.esc_html($total_images_cnt).'</p></div>';
            $output .= '</div>';
          $output .= '</div>';

          $output .= '<div class="dtdr-listings-item-title">';
            $output .= '<a href="'.get_permalink($listing_id).'">'.get_the_title($listing_id).'</a>';
          $output .= '</div>';

          if(shortcode_exists('dtdr_sp_price')) {
            $output .= do_shortcode('[dtdr_sp_price listing_id="'.esc_attr($listing_id).'" /]');
          }

        $output .= '</div>';

      $output .= '</div>';

    } else if($type == 'type3') {

      $output .= '<div class="'.implode(' ', get_post_class($item_classes, $listing_id)).'">';

        $output .= '<div class="dtdr-listings-item-top-section">';

          $output .= '<div class="dtdr-listings-item-image-gallery">';
            $output .= do_shortcode('[dtdr_sp_featured_image listing_id="'.esc_attr($listing_id).'" image_size="full" /]');
          $output .= '</div>';

          if(shortcode_exists('dtdr_sp_price')) {
            $output .= do_shortcode('[dtdr_sp_price listing_id="'.esc_attr($listing_id).'" /]');
          }

        $output .= '</div>';

        $output .= '<div class="dtdr-listings-item-bottom-section">';

          $output .= '<div class="dtdr-listings-item-title">';
            $output .= '<a href="'.get_permalink($listing_id).'">'.get_the_title($listing_id).'</a>';
          $output .= '</div>';

          $output .= do_shortcode('[dtdr_sp_contact_details listing_id="'.esc_attr($listing_id).'" include_address="true" /]');

        $output .= '</div>';

      $output .= '</div>';

    }

    return $output;

  }
}

// Calculate distance between location

if( !function_exists('dtdr_calculate_distance_between_location') ) {
  function dtdr_calculate_distance_between_location($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $unit) {

    $googlemap_api_key = dtdr_option('map', 'googlemap-api-key');

    $url = 'https://maps.googleapis.com/maps/api/distancematrix/json?origins='.$latitudeFrom.','.$longitudeFrom.'&destinations='.$latitudeTo.",".$longitudeTo.'&mode=driving&units=metric&key='.$googlemap_api_key;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    $response = curl_exec($ch);
    curl_close($ch);
    $response_a = json_decode($response, true);

    if(isset($response_a['rows'][0]['elements'][0]['distance']['value'])) {

      $distance = $response_a['rows'][0]['elements'][0]['distance']['value'];

      if ($unit == 'km') {
        $finaldistance = ($distance/1000);
        $finaldistance = round($finaldistance, 0);
        return $finaldistance;
      } else if ($unit == 'mi') {
        $finaldistance = ($distance * 0.00062137);
        $finaldistance = round($finaldistance, 0);
        return $finaldistance;
      } else {
        return $distance;
      }

    } else {
      return -1;
    }

  }
}

if( !function_exists('dtdr_countries_list') ) {
    function dtdr_countries_list($with_none = false) {

      $Countries = array (
            'US' => esc_html__('United States', 'dtdr'),
            'CA' => esc_html__('Canada', 'dtdr'),
            'AU' => esc_html__('Australia', 'dtdr'),
            'FR' => esc_html__('France', 'dtdr'),
            'DE' => esc_html__('Germany', 'dtdr'),
            'IS' => esc_html__('Iceland', 'dtdr'),
            'IE' => esc_html__('Ireland', 'dtdr'),
            'IT' => esc_html__('Italy', 'dtdr'),
            'ES' => esc_html__('Spain', 'dtdr'),
            'SE' => esc_html__('Sweden', 'dtdr'),
            'AT' => esc_html__('Austria', 'dtdr'),
            'BE' => esc_html__('Belgium', 'dtdr'),
            'FI' => esc_html__('Finland', 'dtdr'),
            'CZ' => esc_html__('Czech Republic', 'dtdr'),
            'DK' => esc_html__('Denmark', 'dtdr'),
            'NO' => esc_html__('Norway', 'dtdr'),
            'GB' => esc_html__('United Kingdom', 'dtdr'),
            'CH' => esc_html__('Switzerland', 'dtdr'),
            'NZ' => esc_html__('New Zealand', 'dtdr'),
            'RU' => esc_html__('Russian Federation', 'dtdr'),
            'PT' => esc_html__('Portugal', 'dtdr'),
            'NL' => esc_html__('Netherlands', 'dtdr'),
            'IM' => esc_html__('Isle of Man', 'dtdr'),
            'AF' => esc_html__('Afghanistan', 'dtdr'),
            'AX' => esc_html__('Aland Islands ', 'dtdr'),
            'AL' => esc_html__('Albania', 'dtdr'),
            'DZ' => esc_html__('Algeria', 'dtdr'),
            'AS' => esc_html__('American Samoa', 'dtdr'),
            'AD' => esc_html__('Andorra', 'dtdr'),
            'AO' => esc_html__('Angola', 'dtdr'),
            'AI' => esc_html__('Anguilla', 'dtdr'),
            'AQ' => esc_html__('Antarctica', 'dtdr'),
            'AG' => esc_html__('Antigua and Barbuda', 'dtdr'),
            'AR' => esc_html__('Argentina', 'dtdr'),
            'AM' => esc_html__('Armenia', 'dtdr'),
            'AW' => esc_html__('Aruba', 'dtdr'),
            'AZ' => esc_html__('Azerbaijan', 'dtdr'),
            'BS' => esc_html__('Bahamas', 'dtdr'),
            'BH' => esc_html__('Bahrain', 'dtdr'),
            'BD' => esc_html__('Bangladesh', 'dtdr'),
            'BB' => esc_html__('Barbados', 'dtdr'),
            'BY' => esc_html__('Belarus', 'dtdr'),
            'BZ' => esc_html__('Belize', 'dtdr'),
            'BJ' => esc_html__('Benin', 'dtdr'),
            'BM' => esc_html__('Bermuda', 'dtdr'),
            'BT' => esc_html__('Bhutan', 'dtdr'),
            'BO' => esc_html__('Bolivia, Plurinational State of', 'dtdr'),
            'BQ' => esc_html__('Bonaire, Sint Eustatius and Saba', 'dtdr'),
            'BA' => esc_html__('Bosnia and Herzegovina', 'dtdr'),
            'BW' => esc_html__('Botswana', 'dtdr'),
            'BV' => esc_html__('Bouvet Island', 'dtdr'),
            'BR' => esc_html__('Brazil', 'dtdr'),
            'IO' => esc_html__('British Indian Ocean Territory', 'dtdr'),
            'BN' => esc_html__('Brunei Darussalam', 'dtdr'),
            'BG' => esc_html__('Bulgaria', 'dtdr'),
            'BF' => esc_html__('Burkina Faso', 'dtdr'),
            'BI' => esc_html__('Burundi', 'dtdr'),
            'KH' => esc_html__('Cambodia', 'dtdr'),
            'CM' => esc_html__('Cameroon', 'dtdr'),
            'CV' => esc_html__('Cape Verde', 'dtdr'),
            'KY' => esc_html__('Cayman Islands', 'dtdr'),
            'CF' => esc_html__('Central African Republic', 'dtdr'),
            'TD' => esc_html__('Chad', 'dtdr'),
            'CL' => esc_html__('Chile', 'dtdr'),
            'CN' => esc_html__('China', 'dtdr'),
            'CX' => esc_html__('Christmas Island', 'dtdr'),
            'CC' => esc_html__('Cocos (Keeling) Islands', 'dtdr'),
            'CO' => esc_html__('Colombia', 'dtdr'),
            'KM' => esc_html__('Comoros', 'dtdr'),
            'CG' => esc_html__('Congo', 'dtdr'),
            'CD' => esc_html__('Congo, the Democratic Republic of the', 'dtdr'),
            'CK' => esc_html__('Cook Islands', 'dtdr'),
            'CR' => esc_html__('Costa Rica', 'dtdr'),
            'CI' => esc_html__("Cote d'Ivoire", 'dtdr'),
            'HR' => esc_html__('Croatia', 'dtdr'),
            'CU' => esc_html__('Cuba', 'dtdr'),
            'CW' => esc_html__('Curacao', 'dtdr'),
            'CY' => esc_html__('Cyprus', 'dtdr'),
            'DJ' => esc_html__('Djibouti', 'dtdr'),
            'DM' => esc_html__('Dominica', 'dtdr'),
            'DO' => esc_html__('Dominican Republic', 'dtdr'),
            'EC' => esc_html__('Ecuador', 'dtdr'),
            'EG' => esc_html__('Egypt', 'dtdr'),
            'SV' => esc_html__('El Salvador', 'dtdr'),
            'GQ' => esc_html__('Equatorial Guinea', 'dtdr'),
            'ER' => esc_html__('Eritrea', 'dtdr'),
            'EE' => esc_html__('Estonia', 'dtdr'),
            'ET' => esc_html__('Ethiopia', 'dtdr'),
            'FK' => esc_html__('Falkland Islands (Malvinas)', 'dtdr'),
            'FO' => esc_html__('Faroe Islands', 'dtdr'),
            'FJ' => esc_html__('Fiji', 'dtdr'),
            'GF' => esc_html__('French Guiana', 'dtdr'),
            'PF' => esc_html__('French Polynesia', 'dtdr'),
            'TF' => esc_html__('French Southern Territories', 'dtdr'),
            'GA' => esc_html__('Gabon', 'dtdr'),
            'GM' => esc_html__('Gambia', 'dtdr'),
            'GE' => esc_html__('Georgia', 'dtdr'),
            'GH' => esc_html__('Ghana', 'dtdr'),
            'GI' => esc_html__('Gibraltar', 'dtdr'),
            'GR' => esc_html__('Greece', 'dtdr'),
            'GL' => esc_html__('Greenland', 'dtdr'),
            'GD' => esc_html__('Grenada', 'dtdr'),
            'GP' => esc_html__('Guadeloupe', 'dtdr'),
            'GU' => esc_html__('Guam', 'dtdr'),
            'GT' => esc_html__('Guatemala', 'dtdr'),
            'GG' => esc_html__('Guernsey', 'dtdr'),
            'GN' => esc_html__('Guinea', 'dtdr'),
            'GW' => esc_html__('Guinea-Bissau', 'dtdr'),
            'GY' => esc_html__('Guyana', 'dtdr'),
            'HT' => esc_html__('Haiti', 'dtdr'),
            'HM' => esc_html__('Heard Island and McDonald Islands', 'dtdr'),
            'VA' => esc_html__('Holy See (Vatican City State)', 'dtdr'),
            'HN' => esc_html__('Honduras', 'dtdr'),
            'HK' => esc_html__('Hong Kong', 'dtdr'),
            'HU' => esc_html__('Hungary', 'dtdr'),
            'IN' => esc_html__('India', 'dtdr'),
            'ID' => esc_html__('Indonesia', 'dtdr'),
            'IR' => esc_html__('Iran, Islamic Republic of', 'dtdr'),
            'IQ' => esc_html__('Iraq', 'dtdr'),
            'IL' => esc_html__('Israel', 'dtdr'),
            'JM' => esc_html__('Jamaica', 'dtdr'),
            'JP' => esc_html__('Japan', 'dtdr'),
            'JE' => esc_html__('Jersey', 'dtdr'),
            'JO' => esc_html__('Jordan', 'dtdr'),
            'KZ' => esc_html__('Kazakhstan', 'dtdr'),
            'KE' => esc_html__('Kenya', 'dtdr'),
            'KI' => esc_html__('Kiribati', 'dtdr'),
            'KP' => esc_html__('Korea, Democratic People\'s Republic of', 'dtdr'),
            'KR' => esc_html__('Korea, Republic of', 'dtdr'),
            'KV' => esc_html__('kosovo', 'dtdr'),
            'KW' => esc_html__('Kuwait', 'dtdr'),
            'KG' => esc_html__('Kyrgyzstan', 'dtdr'),
            'LA' => esc_html__('Lao People\'s Democratic Republic', 'dtdr'),
            'LV' => esc_html__('Latvia', 'dtdr'),
            'LB' => esc_html__('Lebanon', 'dtdr'),
            'LS' => esc_html__('Lesotho', 'dtdr'),
            'LR' => esc_html__('Liberia', 'dtdr'),
            'LY' => esc_html__('Libyan Arab Jamahiriya', 'dtdr'),
            'LI' => esc_html__('Liechtenstein', 'dtdr'),
            'LT' => esc_html__('Lithuania', 'dtdr'),
            'LU' => esc_html__('Luxembourg', 'dtdr'),
            'MO' => esc_html__('Macao', 'dtdr'),
            'MK' => esc_html__('Macedonia', 'dtdr'),
            'MG' => esc_html__('Madagascar', 'dtdr'),
            'MW' => esc_html__('Malawi', 'dtdr'),
            'MY' => esc_html__('Malaysia', 'dtdr'),
            'MV' => esc_html__('Maldives', 'dtdr'),
            'ML' => esc_html__('Mali', 'dtdr'),
            'MT' => esc_html__('Malta', 'dtdr'),
            'MH' => esc_html__('Marshall Islands', 'dtdr'),
            'MQ' => esc_html__('Martinique', 'dtdr'),
            'MR' => esc_html__('Mauritania', 'dtdr'),
            'MU' => esc_html__('Mauritius', 'dtdr'),
            'YT' => esc_html__('Mayotte', 'dtdr'),
            'MX' => esc_html__('Mexico', 'dtdr'),
            'FM' => esc_html__('Micronesia, Federated States of', 'dtdr'),
            'MD' => esc_html__('Moldova, Republic of', 'dtdr'),
            'MC' => esc_html__('Monaco', 'dtdr'),
            'MN' => esc_html__('Mongolia', 'dtdr'),
            'ME' => esc_html__('Montenegro', 'dtdr'),
            'MS' => esc_html__('Montserrat', 'dtdr'),
            'MA' => esc_html__('Morocco', 'dtdr'),
            'MZ' => esc_html__('Mozambique', 'dtdr'),
            'MM' => esc_html__('Myanmar', 'dtdr'),
            'NA' => esc_html__('Namibia', 'dtdr'),
            'NR' => esc_html__('Nauru', 'dtdr'),
            'NP' => esc_html__('Nepal', 'dtdr'),
            'NC' => esc_html__('New Caledonia', 'dtdr'),
            'NI' => esc_html__('Nicaragua', 'dtdr'),
            'NE' => esc_html__('Niger', 'dtdr'),
            'NG' => esc_html__('Nigeria', 'dtdr'),
            'NU' => esc_html__('Niue', 'dtdr'),
            'NF' => esc_html__('Norfolk Island', 'dtdr'),
            'MP' => esc_html__('Northern Mariana Islands', 'dtdr'),
            'OM' => esc_html__('Oman', 'dtdr'),
            'PK' => esc_html__('Pakistan', 'dtdr'),
            'PW' => esc_html__('Palau', 'dtdr'),
            'PS' => esc_html__('Palestinian Territory, Occupied', 'dtdr'),
            'PA' => esc_html__('Panama', 'dtdr'),
            'PG' => esc_html__('Papua New Guinea', 'dtdr'),
            'PY' => esc_html__('Paraguay', 'dtdr'),
            'PE' => esc_html__('Peru', 'dtdr'),
            'PH' => esc_html__('Philippines', 'dtdr'),
            'PN' => esc_html__('Pitcairn', 'dtdr'),
            'PL' => esc_html__('Poland', 'dtdr'),
            'PR' => esc_html__('Puerto Rico', 'dtdr'),
            'QA' => esc_html__('Qatar', 'dtdr'),
            'RE' => esc_html__('Reunion', 'dtdr'),
            'RO' => esc_html__('Romania', 'dtdr'),
            'RW' => esc_html__('Rwanda', 'dtdr'),
            'BL' => esc_html__('Saint Barthelemy', 'dtdr'),
            'SH' => esc_html__('Saint Helena', 'dtdr'),
            'KN' => esc_html__('Saint Kitts and Nevis', 'dtdr'),
            'LC' => esc_html__('Saint Lucia', 'dtdr'),
            'MF' => esc_html__('Saint Martin (French part)', 'dtdr'),
            'PM' => esc_html__('Saint Pierre and Miquelon', 'dtdr'),
            'VC' => esc_html__('Saint Vincent and the Grenadines', 'dtdr'),
            'WS' => esc_html__('Samoa', 'dtdr'),
            'SM' => esc_html__('San Marino', 'dtdr'),
            'ST' => esc_html__('Sao Tome and Principe', 'dtdr'),
            'SA' => esc_html__('Saudi Arabia', 'dtdr'),
            'SN' => esc_html__('Senegal', 'dtdr'),
            'RS' => esc_html__('Serbia', 'dtdr'),
            'SC' => esc_html__('Seychelles', 'dtdr'),
            'SL' => esc_html__('Sierra Leone', 'dtdr'),
            'SG' => esc_html__('Singapore', 'dtdr'),
            'SX' => esc_html__('Sint Maarten (Dutch part)', 'dtdr'),
            'SK' => esc_html__('Slovakia', 'dtdr'),
            'SI' => esc_html__('Slovenia', 'dtdr'),
            'SB' => esc_html__('Solomon Islands', 'dtdr'),
            'SO' => esc_html__('Somalia', 'dtdr'),
            'ZA' => esc_html__('South Africa', 'dtdr'),
            'GS' => esc_html__('South Georgia and the South Sandwich Islands', 'dtdr'),
            'LK' => esc_html__('Sri Lanka', 'dtdr'),
            'SD' => esc_html__('Sudan', 'dtdr'),
            'SR' => esc_html__('Suriname', 'dtdr'),
            'SJ' => esc_html__('Svalbard and Jan Mayen', 'dtdr'),
            'SZ' => esc_html__('Swaziland', 'dtdr'),
            'SY' => esc_html__('Syrian Arab Republic', 'dtdr'),
            'TW' => esc_html__('Taiwan, Province of China', 'dtdr'),
            'TJ' => esc_html__('Tajikistan', 'dtdr'),
            'TZ' => esc_html__('Tanzania, United Republic of', 'dtdr'),
            'TH' => esc_html__('Thailand', 'dtdr'),
            'TL' => esc_html__('Timor-Leste', 'dtdr'),
            'TG' => esc_html__('Togo', 'dtdr'),
            'TK' => esc_html__('Tokelau', 'dtdr'),
            'TO' => esc_html__('Tonga', 'dtdr'),
            'TT' => esc_html__('Trinidad and Tobago', 'dtdr'),
            'TN' => esc_html__('Tunisia', 'dtdr'),
            'TR' => esc_html__('Turkey', 'dtdr'),
            'TM' => esc_html__('Turkmenistan', 'dtdr'),
            'TC' => esc_html__('Turks and Caicos Islands', 'dtdr'),
            'TV' => esc_html__('Tuvalu', 'dtdr'),
            'UG' => esc_html__('Uganda', 'dtdr'),
            'UA' => esc_html__('Ukraine', 'dtdr'),
            'AE' => esc_html__('United Arab Emirates', 'dtdr'),
            'UM' => esc_html__('United States Minor Outlying Islands', 'dtdr'),
            'UY' => esc_html__('Uruguay', 'dtdr'),
            'UZ' => esc_html__('Uzbekistan', 'dtdr'),
            'VU' => esc_html__('Vanuatu', 'dtdr'),
            'VE' => esc_html__('Venezuela, Bolivarian Republic of', 'dtdr'),
            'VN' => esc_html__('Viet Nam', 'dtdr'),
            'VG' => esc_html__('Virgin Islands, British', 'dtdr'),
            'VI' => esc_html__('Virgin Islands, U.S.', 'dtdr'),
            'WF' => esc_html__('Wallis and Futuna', 'dtdr'),
            'EH' => esc_html__('Western Sahara', 'dtdr'),
            'YE' => esc_html__('Yemen', 'dtdr'),
            'ZM' => esc_html__('Zambia', 'dtdr'),
            'ZW' => esc_html__('Zimbabwe', 'dtdr')
        );

      if($with_none) {
            $Countries = array ('' => esc_html__('None', 'dtdr'))+$Countries;
      }

      return $Countries;

    }
}

?>