<?php

function dtdr_statistics_options() {

	$listing_plural_label = apply_filters( 'listing_label', 'plural' );
	$seller_plural_label = apply_filters( 'seller_label', 'plural' );

	$tabs = array (
		'listings'   => array (
			'label' => $listing_plural_label,
			'callback' => 'dtdr_statistics_listings_content',
			'path' => dtdrStatisticsModule()->module_path . 'statistics-listings.php'
		),
		'sellers'     =>  array (
			'label' => $seller_plural_label,
			'path' => dtdrStatisticsModule()->module_path . 'statistics-sellers.php'
		),
		'packages'     =>  array (
			'label' => esc_html__('Packages', 'dtdr'),
			'path' => dtdrStatisticsModule()->module_path . 'statistics-packages.php'
		)
	);

	$tabs = apply_filters( 'dtdr_statistics', $tabs );

	$current = isset( $_GET['parenttab'] ) ? dtdr_recursive_sanitize_text_field($_GET['parenttab']) : 'listings';

	dtdr_get_statistics_submenus($current, $tabs);
	dtdr_get_statistics_tab($current, $tabs);

}

function dtdr_get_statistics_submenus($current, $tabs) {

	echo '<h2 class="dtdr-custom-nav nav-tab-wrapper">';
		foreach( $tabs as $key => $tab ) {
			$class = ( $key == $current ) ? 'nav-tab-active' : '';
			echo '<a class="nav-tab '.$class.'" href="?page=dtdr-statistics-options&parenttab='.$key.'">'.$tab['label'].'</a>';
		}
	echo '</h2>';

}

function dtdr_get_statistics_tab($current, $tabs) {

	require_once $tabs[$current]['path'];
	call_user_func($tabs[$current]['callback']);

}

?>