<?php
/**
 * Recommends plugins for use with the theme via the TGMA Script
 *
 * @package Advenx WordPress theme
 */

function advenx_tgmpa_plugins_register() {

  

	// Get array of recommended plugins.
	$plugins_list = array(

       

        array(
            'name'               => esc_html__('Advenx Plus', 'advenx'),
            'slug'               => 'advenx-plus',
            'source'             => ADVENX_MODULE_DIR . '/plugins/advenx-plus.zip',
            'required'           => true,
            'version'            => '1.0.4',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('Advenx Pro', 'advenx'),
            'slug'               => 'advenx-pro',
            'source'             => ADVENX_MODULE_DIR . '/plugins/advenx-pro.zip',
            'required'           => true,
            'version'            => '1.0.7',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('Elementor', 'advenx'),
            'slug'     => 'elementor',
            'required' => true,
        ),
        array(
            'name'               => esc_html__('WeDesignTech Elementor Addon', 'advenx'),
            'slug'               => 'wedesigntech-elementor-addon',
            'source'             => ADVENX_MODULE_DIR . '/plugins/wedesigntech-elementor-addon.zip',
            'required'           => true,
            'version'            => '1.1.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('WeDesignTech Destination', 'advenx'),
            'slug'               => 'wedesigntech-destination',
            'source'             => ADVENX_MODULE_DIR . '/plugins/wedesigntech-destination.zip',
            'required'           => true,
            'version'            => '1.0.3',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('WeDesignTech Directory Addon', 'advenx'),
            'slug'               => 'wedesigntech-directory-addon',
            'source'             => ADVENX_MODULE_DIR . '/plugins/wedesigntech-directory-addon.zip',
            'required'           => true,
            'version'            => '1.0.5',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('WooCommerce', 'advenx'),
            'slug'     => 'woocommerce',
            'required' => false,
        ),
        array(
            'name'               => esc_html__('Advenx Shop', 'advenx'),
            'slug'               => 'advenx-shop',
            'source'             => ADVENX_MODULE_DIR . '/plugins/advenx-shop.zip',
            'required'           => false,
            'version'            => '1.0.2',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('Contact Form 7', 'advenx'),
            'slug'     => 'contact-form-7',
            'required' => true,
        ),
        array(
            'name'               => esc_html__('WDT Demo Importer', 'advenx'),
            'slug'               => 'wdt-demo-importer',
            'source'             => ADVENX_MODULE_DIR . '/plugins/wdt-demo-importer.zip',
            'required'           => true,
            'version'            => '1.0.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        )
	);
    $plugins = apply_filters('advenx_required_plugins_list', $plugins_list);

	// Register notice
	tgmpa( $plugins, array(
		'id'           => 'advenx_theme',
		'domain'       => 'advenx',
		'menu'         => 'install-required-plugins',
		'has_notices'  => true,
		'is_automatic' => true,
		'dismissable'  => true,
	) );

}
add_action( 'tgmpa_register', 'advenx_tgmpa_plugins_register' );