<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Advenx_Shop_Metabox_Single_Upsell_Related' ) ) {
    class Advenx_Shop_Metabox_Single_Upsell_Related {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {

			add_filter( 'advenx_shop_product_custom_settings', array( $this, 'advenx_shop_product_custom_settings' ), 10 );

		}

        function advenx_shop_product_custom_settings( $options ) {

			$ct_dependency      = array ();
			$upsell_dependency  = array ( 'show-upsell', '==', 'true');
			$related_dependency = array ( 'show-related', '==', 'true');
			if( function_exists('advenx_shop_single_module_custom_template') ) {
				$ct_dependency['dependency'] 	= array ( 'product-template', '!=', 'custom-template');
				$upsell_dependency 				= array ( 'product-template|show-upsell', '!=|==', 'custom-template|true');
				$related_dependency 			= array ( 'product-template|show-related', '!=|==', 'custom-template|true');
			}

			$product_options = array (

				array_merge (
					array(
						'id'         => 'show-upsell',
						'type'       => 'select',
						'title'      => esc_html__('Show Upsell Products', 'advenx'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-upsell' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'advenx' ),
							'true'         => esc_html__( 'Show', 'advenx'),
							null           => esc_html__( 'Hide', 'advenx'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'upsell-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Column', 'advenx'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'advenx' ),
						1              => esc_html__( 'One Column', 'advenx' ),
						2              => esc_html__( 'Two Columns', 'advenx' ),
						3              => esc_html__( 'Three Columns', 'advenx' ),
						4              => esc_html__( 'Four Columns', 'advenx' ),
					),
					'dependency' => $upsell_dependency
				),

				array(
					'id'         => 'upsell-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Limit', 'advenx'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'advenx' ),
						1              => esc_html__( 'One', 'advenx' ),
						2              => esc_html__( 'Two', 'advenx' ),
						3              => esc_html__( 'Three', 'advenx' ),
						4              => esc_html__( 'Four', 'advenx' ),
						5              => esc_html__( 'Five', 'advenx' ),
						6              => esc_html__( 'Six', 'advenx' ),
						7              => esc_html__( 'Seven', 'advenx' ),
						8              => esc_html__( 'Eight', 'advenx' ),
						9              => esc_html__( 'Nine', 'advenx' ),
						10              => esc_html__( 'Ten', 'advenx' ),
					),
					'dependency' => $upsell_dependency
				),

				array_merge (
					array(
						'id'         => 'show-related',
						'type'       => 'select',
						'title'      => esc_html__('Show Related Products', 'advenx'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-related' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'advenx' ),
							'true'         => esc_html__( 'Show', 'advenx'),
							null           => esc_html__( 'Hide', 'advenx'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'related-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Column', 'advenx'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'advenx' ),
						2              => esc_html__( 'Two Columns', 'advenx' ),
						3              => esc_html__( 'Three Columns', 'advenx' ),
						4              => esc_html__( 'Four Columns', 'advenx' ),
					),
					'dependency' => $related_dependency
				),

				array(
					'id'         => 'related-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Limit', 'advenx'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'advenx' ),
						1              => esc_html__( 'One', 'advenx' ),
						2              => esc_html__( 'Two', 'advenx' ),
						3              => esc_html__( 'Three', 'advenx' ),
						4              => esc_html__( 'Four', 'advenx' ),
						5              => esc_html__( 'Five', 'advenx' ),
						6              => esc_html__( 'Six', 'advenx' ),
						7              => esc_html__( 'Seven', 'advenx' ),
						8              => esc_html__( 'Eight', 'advenx' ),
						9              => esc_html__( 'Nine', 'advenx' ),
						10              => esc_html__( 'Ten', 'advenx' ),
					),
					'dependency' => $related_dependency
				)

			);

			$options = array_merge( $options, $product_options );

			return $options;

		}

    }
}

Advenx_Shop_Metabox_Single_Upsell_Related::instance();